/*
   Tom'Catalog
   Copyright 2002, Thomas Aufischer

   based on:

   Z'Catalog: a PalmOS database utility
   Copyright 1998, Andrew Plotkin <erkyrath@eblong.com>
   http://www.eblong.com/zarf/zcatalog.html

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <PalmOS.h>
#include "zcatalog.h"
#include "resource.h"

/* The form handler for the Preferences form. */

static FormPtr prefform = NULL;

#define mGetObject(id)  \
    (FrmGetObjectPtr(prefform, FrmGetObjectIndex(prefform, (id))))

static void PREFS_init(FormPtr frm)
{
  ControlPtr ctl;

  prefform = frm;

  ctl = mGetObject(chk_PrefsBonehead);
  CtlSetValue(ctl, MAIN_gBoneheadmode);
  ctl = mGetObject(chk_PrefsUSDateTime);
  CtlSetValue(ctl, MAIN_gUSDateTime);
}

Boolean PREFS_hanevent(EventPtr event)
{
  Boolean handled = FALSE;
  ControlPtr ctl;

  switch (event->eType)
  {
    case frmOpenEvent:
      PREFS_init(FrmGetActiveForm());
      FrmDrawForm(prefform);
      handled = TRUE;
      break;

    case frmCloseEvent:
      prefform = NULL;
      /* and pass on */
      break;

    case ctlSelectEvent:
      switch (event->data.ctlSelect.controlID)
      {
        case btn_PrefsDone:
          ctl = mGetObject(chk_PrefsBonehead);
          MAIN_gBoneheadmode = CtlGetValue(ctl);
          ctl = mGetObject(chk_PrefsUSDateTime);
          MAIN_gUSDateTime = CtlGetValue(ctl);
          FrmReturnToForm(formid_Main);
          handled = TRUE;
      }
      break;
  }

  return handled;
}
