/*
   Tom'Catalog
   Copyright 2002, Thomas Aufischer

   based on:

   Z'Catalog: a PalmOS database utility
   Copyright 1998, Andrew Plotkin <erkyrath@eblong.com>
   http://www.eblong.com/zarf/zcatalog.html

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <PalmOS.h>
#include "zcatalog.h"
#include "resource.h"

/* Test if the OS version is high enough to run the program.
   Also set the MAIN_gOS3_avail flag. */
Err UTIL_RomVersionCompatible(UInt32 required, UInt16 launchflags)
{
  UInt32 romVersion;

  FtrGet(sysFtrCreator, sysFtrNumROMVersion, &romVersion);

  if(romVersion < required)
  {
    if((launchflags & sysAppLaunchFlagNewGlobals)
       && (launchflags & sysAppLaunchFlagUIApp))
    {
      FrmAlert(alertid_ROMTooOld);

      /* Pilot 1.0 will continuously relaunch this app unless we switch to another safe one. */
      if(romVersion < sysMakeROMVersion(2, 0, 0, sysROMStageRelease, 0))
      {
        AppLaunchWithCommand(sysFileCDefaultApp, sysAppLaunchCmdNormalLaunch, NULL);
      }
    }

    return sysErrRomIncompatible;
  }

  if(romVersion >= 0x03000000)
  {
    MAIN_gOS3_avail = TRUE;
  }

  return 0;
}

void UTIL_printError(char *s1)
{
  FrmCustomAlert(alertid_Error, s1, "", "");
}

#ifdef ZDEBUG

void UTIL_printDebug(char *s1, char *s2, char *s3)
{
  if(!s1 || !(*s1))
  {
    s1 = " ";
  }
  if(!s2 || !(*s2))
  {
    s2 = " ";
  }
  if(!s3 || !(*s3))
  {
    s3 = " ";
  }

  FrmCustomAlert(alertid_DebugNote, s1, s2, s3);
}

void UTIL_printDebugInt(Int32 i1, char *s2, char *s3)
{
  char s1[dmDBNameLength];

  StrIToA(s1, i1);

  if(!s2 || !(*s2))
  {
    s2 = " ";
  }
  if(!s3 || !(*s3))
  {
    s3 = " ";
  }

  FrmCustomAlert(alertid_DebugNote, s1, s2, s3);
}

void UTIL_printDebugIntIntInt(Int32 i1, Int32 i2, Int32 i3)
{
  char s1[dmDBNameLength];
  char s2[dmDBNameLength];
  char s3[dmDBNameLength];

  StrIToA(s1, i1);
  StrIToA(s2, i2);
  StrIToA(s3, i3);

  FrmCustomAlert(alertid_DebugNote, s1, s2, s3);
}

#endif /* ZDEBUG */
