/*
   Tom'Catalog
   Copyright 2002, Thomas Aufischer

   based on:

   Z'Catalog: a PalmOS database utility
   Copyright 1998, Andrew Plotkin <erkyrath@eblong.com>
   http://www.eblong.com/zarf/zcatalog.html

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef Z_IMPORTED
#define Z_IMPORTED

/* If this is defined, the program starts up with safety mode turned off
   by default, instead of on.
*/
//#define ZDEBUG

/* I can never tell whether TRUE and FALSE are defined any more. Define
   them just in case. */
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define Z_mOSTypeToBuf(buf, id)  (  \
    (buf)[0] = (((id) >> 24) & 0xff),  \
    (buf)[1] = (((id) >> 16) & 0xff),  \
    (buf)[2] = (((id) >> 8) & 0xff),  \
    (buf)[3] = ((id) & 0xff),  \
    (buf)[4] = '\0')

/* Useful constants */
#define Z_dSelfCreator 'taCT'
#define Z_dSelfMimetype "application/x-tomcatalog"

/* Number of data columns, excluding the name */
#define Z_dNumColumns (3)

#define Z_dColumnTypeName (-1) /* Can't be a data column */
#define Z_dColumnTypeType (0)
#define Z_dColumnTypeCreator (1)
#define Z_dColumnTypeSize (2)
#define Z_dColumnTypeRecords (3)
#define Z_dColumnTypeAttributes (4)
#define Z_dColumnTypeCreated (5)
#define Z_dColumnTypeModified (6)
#define Z_dColumnTypeBackuped (7)
#define Z_dColumnTypeCreatedTime (8)
#define Z_dColumnTypeModifiedTime (9)
#define Z_dColumnTypeBackupedTime (10)
#define Z_dColumnTypeRWRO (11)
#define Z_dColumnTypeVersion (12)
#define Z_dColumnTypeCard (13)
/** ADD NEW ITEMS ALSO TO Z_cColumnName AND INCREASE THE NUMBER BELOW */
/** number of all data columns, including the name */
#define Z_dNumColumnTypes (14)

/** names of columns, as in .rcp */
static const char *Z_cColumnName[Z_dNumColumnTypes] = {
  "Type", "Creat", "Size", "Recs", "Attr", "CreaD", "ModD", "BackD", "CreaT",
  "ModT", "BackT", "RW/RO", "Vers.M", "Card"
};

// that's shorter then dmDBNameLength because we can'T display the full name
#define Z_dDBNameLength (16)

enum Z_eLocationEnum {
    TOOL_eLocation_RAM = 0,
    TOOL_eLocation_ROM,
    TOOL_eLocation_FLASH
};

static const char *Z_cLocationString[]
  = { "RAM", "ROM", "FLS" };


/* A Z_DBInfo represents a single database in the catalog. */
typedef struct Z_DBInfo_Struct {
  UInt16 card;
  /*UInt index;*/
  LocalID lid;
  char name[dmDBNameLength];
  UInt16 attributes; /* dmHdrAttr*, from DataMgr.h */
  Boolean inrom;
  UInt32 type;
  UInt32 creator;
  UInt32 records;
  UInt32 size; /* including overhead */
  UInt32 created;
  UInt32 modified;
  UInt32 backuped;
  UInt16 version;
  UInt32 modifier;
} Z_DBInfo;

typedef struct Z_Column_Struct {
  Int16 list_resid;
  Int16 pop_resid;
  Int16 type; /* what type the column displays */
} Z_Column;

typedef struct Z_Filter_Struct {
  Int16 active;
  Int16 type;
  Int16 test;
  union {
    UInt32 ostype;
    Int32 num;
    char str[17];
  } u;
} Z_Filter;

#define Z_dPrefsResid (0)
#define Z_dPrefsVersion (6)

typedef struct Z_Preferences_Struct
{
  Int16 bonehead;
  Int16 usDateTime;

  Int16 coltype[Z_dNumColumns];

  Int16 sortType;
  Int16 showReadonly;
  Int16 sortReverse;
  Z_Filter filter;

  Int16 isselect;
  char selectname[dmDBNameLength];
  Int16 selectcol;

  Int16 viewstate; /* 0 for main view, 1 if viewing properties */
  char viewname[dmDBNameLength];
} Z_Preferences;

#define Z_dChangedName (1)
#define Z_dChangedAttr (2)
#define Z_dChangedType (4)
#define Z_dChangedCreator (8)
#define Z_dChangedTimes (16)

typedef struct Z_Changedata_Struct
{
  char name[dmDBNameLength];
  UInt32 type;
  UInt32 creator;
  UInt16 attributes;
  UInt32 create_date, mod_date, backup_date;
} Z_Changedata;

/* structure for date/time */
typedef struct Z_DateTime_Struct
{
  UInt32 base;

  Boolean active;
  DateTimeType fields;
  char date_buf[Z_dDBNameLength];
  char time_buf[Z_dDBNameLength];
}
Z_DateTime;

extern Boolean MAIN_gBoneheadmode; /* Safety mode flag */
extern Boolean MAIN_gUSDateTime;
extern Boolean MAIN_gOS3_avail; /* Are OS3 features available? */

/* The top-level form of the app. */
extern FormPtr MAIN_gMainform;

/** stores the last selected type to sort: e.g. name, type, size, .. */
extern Int16 SORT_gSortType;
/** stores if the last selected sort was reverse*/
extern Int16 SORT_gSortReverse;
extern Z_Filter SORT_gFilter;
extern Int16 SORT_gShowReadonly;
extern Z_Column SORT_gColumnState[Z_dNumColumns];
extern const char *Z_cColumnName[Z_dNumColumnTypes];

/** number of ALL DB's */
extern Int32 DBI_gNumDBs;
/** ALL DB's - POINTERS! */
extern Z_DBInfo **DBI_gDBList;
/** number of FILTERED DB's */
extern Int32 DBI_gNumTabs;
/** FILTERED DB's -> index in ALL DB's */
extern Int32 *DBI_gTabList;

extern void MAIN_mainform_dirty_dbist(Int16 val);
extern void MAIN_mainform_notice_new_db(UInt16 card, LocalID lid);

extern void MTAB_maintab_init(void);
extern void MTAB_maintab_final(void);
extern void MTAB_maintab_reload(void);
extern void MTAB_maintab_redraw_careful( Boolean unhighlight );
extern void MTAB_maintab_redraw(void);
extern void MTAB_maintab_scroll(Boolean down, Boolean oneline);
extern void MTAB_maintab_notice_selection(Int16 row, Int16 col);
extern void MTAB_maintab_set_init_selection(Boolean isselect, char *name,
               Int16 col);
extern void MTAB_maintab_get_selection_dbi(Int32 *dbi, Int16 *col);
extern void MTAB_change_inval_column(Int16 col);
extern void MTAB_sanitize_selscroll(void);
extern void MTAB_do_sort(Int16 type, Int16 reverse);
extern void MTAB_do_name_header(Int16 newval);
extern void MTAB_do_column_header(Int16 dcol, Int16 newval);
extern void MTAB_do_filter_readonly(Boolean newval);
extern void MTAB_do_refilter(void);
extern char* MTAB_getString(Int32 dbi, Int16 columnType, char *helpBuffer, Int16 *length );

extern void DBI_load_dbinfo(void);
extern void DBI_unload_dbinfo(void);
extern Int32 DBI_find_dbi_by_name(char *name);

extern void SORT_set_default_column_state(void);
extern void SORT_load_pref_column_state(Z_Preferences *pref);
extern void SORT_unload_pref_column_state(Z_Preferences *pref);
extern void SORT_build_tabList(void);
extern Int32 SORT_build_list_for_creator(UInt32, UInt32 *);

extern void FILT_filterform_prepare(Int16 type, Z_DBInfo *val);
extern Boolean FILT_filterform_hanevent(EventPtr event);

extern void PROP_propform_prepare(Int32 dbi);
extern Boolean PROP_propform_hanevent(EventPtr event);
extern Boolean PROP_propform_unload_state(Z_Preferences *prefs);

extern Boolean PREFS_hanevent(EventPtr event);

struct ExgSocketType;
extern Err TOOL_beam_receive_db(struct ExgSocketType *sock, Boolean globavail);
extern Err TOOL_beam_send_db(Z_DBInfo *db);
extern char* TOOL_deleteChar( char *input, Int16* len, char toDelete );
extern char* TOOL_replaceChar( char *input, Int16* len, char from, char to );
extern Int16 TOOL_location(UInt16 card, LocalID lid);
extern const char* TOOL_locationString(UInt16 card, LocalID lid);
extern Boolean TOOL_delete_whole_db(UInt16 card, LocalID lid, UInt32 type, Int16 showAlert);
extern Boolean TOOL_change_prop_db(Int16 changes, Z_Changedata *newdat, UInt16 card, LocalID lid);
extern char* TOOL_getRWString( Int32 dbi, char* buffer );
extern UInt32 TOOL_temp_to_base(Z_DateTime * tem);
extern void TOOL_fill_out_temp(Z_DateTime * tem);
extern void TOOL_dateTimeString(Z_DateTime * tem);
extern char* TOOL_dateStringShort( UInt32 dateTimeInt, char* helpBuffer, Int16* len );
extern char* TOOL_timeStringShort( UInt32 dateTimeInt, char* helpBuffer, Int16* len );
extern void TOOL_getCardInfo( char *text );
extern void TOOL_getSystemInfo( char *text );


#define UTIL_SECTION  __attribute__ ((section ("util")))

extern Err UTIL_RomVersionCompatible(UInt32 required, UInt16 launchflags) UTIL_SECTION;
extern void UTIL_printError(char *s1) UTIL_SECTION;

#ifdef ZDEBUG

extern void UTIL_printDebug(char *s1, char *s2, char *s3) UTIL_SECTION;
extern void UTIL_printDebugInt(Int32 i1, char *s2, char *s3) UTIL_SECTION;
extern void UTIL_printDebugIntIntInt(Int32 i1, Int32 i2, Int32 i3) UTIL_SECTION;

#endif /* ZDEBUG */

#endif